<!-- FILE: tambahstok.php -->
<?php
session_start();
include 'koneksi.php';

// Cek apakah user sudah login dan memiliki hak akses
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'petugas') {
    echo "<script>alert('Anda tidak memiliki akses untuk menambah stok!'); window.location='stokapoteker.php';</script>";
    exit();
}

if (isset($_POST['tambah'])) {
    $id_obat = mysqli_real_escape_string($conn, $_POST['id_obat']);
    $id_gudang = mysqli_real_escape_string($conn, $_POST['id_gudang']);
    $jumlah = mysqli_real_escape_string($conn, $_POST['jumlah']);
    $redirect_to = isset($_POST['redirect_to']) ? $_POST['redirect_to'] : 'stokapoteker.php';

    // Validasi input
    if (empty($id_obat) || empty($id_gudang) || empty($jumlah)) {
        echo "<script>alert('Semua field harus diisi!'); window.location='$redirect_to';</script>";
        exit();
    }

    // Validasi jumlah harus lebih dari 0
    if ($jumlah <= 0) {
        echo "<script>alert('Jumlah stok harus lebih dari 0!'); window.location='$redirect_to';</script>";
        exit();
    }

    // Cek apakah obat ada
    $cek_obat = "SELECT * FROM obat WHERE id_obat = '$id_obat'";
    $result_obat = mysqli_query($conn, $cek_obat);
    
    if (mysqli_num_rows($result_obat) == 0) {
        echo "<script>alert('Obat tidak ditemukan!'); window.location='$redirect_to';</script>";
        exit();
    }

    // Cek apakah gudang ada
    $cek_gudang = "SELECT * FROM gudang WHERE id_gudang = '$id_gudang'";
    $result_gudang = mysqli_query($conn, $cek_gudang);
    
    if (mysqli_num_rows($result_gudang) == 0) {
        echo "<script>alert('Gudang tidak ditemukan!'); window.location='$redirect_to';</script>";
        exit();
    }

    // Cek apakah stok sudah ada di gudang tersebut
    $cek_stok = "SELECT * FROM stok WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
    $result_stok = mysqli_query($conn, $cek_stok);

    if (mysqli_num_rows($result_stok) > 0) {
        // Jika sudah ada, update jumlah stok (tambahkan)
        $row_stok = mysqli_fetch_assoc($result_stok);
        $jumlah_baru = $row_stok['jumlah'] + $jumlah;
        
        $query_update = "UPDATE stok SET jumlah = '$jumlah_baru' 
                        WHERE id_obat = '$id_obat' AND id_gudang = '$id_gudang'";
        
        if (mysqli_query($conn, $query_update)) {
            $obat_info = mysqli_fetch_assoc($result_obat);
            $gudang_info = mysqli_fetch_assoc($result_gudang);
            echo "<script>
                    alert('Stok berhasil ditambahkan!\\n\\nObat: {$obat_info['nama_obat']}\\nGudang: {$gudang_info['nama_gudang']}\\nStok Sebelumnya: {$row_stok['jumlah']}\\nDitambah: {$jumlah}\\nStok Baru: {$jumlah_baru}'); 
                    window.location='$redirect_to';
                  </script>";
        } else {
            echo "<script>alert('Gagal menambahkan stok!\\nError: " . mysqli_error($conn) . "'); window.location='$redirect_to';</script>";
        }
    } else {
        // Jika belum ada, insert data baru
        $query_insert = "INSERT INTO stok (id_obat, id_gudang, jumlah) 
                        VALUES ('$id_obat', '$id_gudang', '$jumlah')";
        
        if (mysqli_query($conn, $query_insert)) {
            $obat_info = mysqli_fetch_assoc($result_obat);
            $gudang_info = mysqli_fetch_assoc($result_gudang);
            echo "<script>
                    alert('Stok baru berhasil ditambahkan!\\n\\nObat: {$obat_info['nama_obat']}\\nGudang: {$gudang_info['nama_gudang']}\\nJumlah: {$jumlah}'); 
                    window.location='$redirect_to';
                  </script>";
        } else {
            echo "<script>alert('Gagal menambahkan stok!\\nError: " . mysqli_error($conn) . "'); window.location='$redirect_to';</script>";
        }
    }
} else {
    echo "<script>alert('Akses tidak valid!'); window.location='stokapoteker.php';</script>";
}
?>